/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.StringTokenizer;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HMCEntityResolver
implements EntityResolver {
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        int css = systemId.indexOf(":");
        int cssFull = systemId.indexOf("://");
        if (css == -1) {
            throw new SAXException("HMCEntityResolver unable to locate delimiter between protocol and path");
        }
        if (!"file".equals(systemId.substring(0, css))) {
            throw new SAXException("Specified protocol ('" + systemId.substring(0, css) + "') not supported by HMCEntityResolver.");
        }
        String specifiedPath = systemId.substring(css + (cssFull != -1 ? 3 : 1));
        String currentDir = System.getProperty("user.dir");
        String consolePath = System.getProperty("CONSOLE_PATH");
        if (consolePath != null) {
            String adjusted = specifiedPath;
            if (adjusted.startsWith(currentDir)) {
                adjusted = adjusted.substring(currentDir.length());
            }
            adjusted = adjusted.startsWith(File.separator) && consolePath.endsWith(File.separator) ? consolePath.concat(adjusted.substring(1)) : (!adjusted.startsWith(File.separator) && !consolePath.endsWith(File.separator) ? consolePath + File.separator + adjusted : consolePath.concat(adjusted));
            try {
                return this.buildInputSource(publicId, systemId, adjusted);
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
        try {
            return this.buildInputSource(publicId, systemId, specifiedPath);
        }
        catch (FileNotFoundException e) {
            StringTokenizer st = new StringTokenizer(specifiedPath, File.separator, false);
            String fn = null;
            while (st.hasMoreTokens()) {
                fn = st.nextToken();
            }
            try {
                return this.buildInputSource(publicId, systemId, fn);
            }
            catch (FileNotFoundException e2) {
                throw new SAXException("HMCEntityResolver unable to locate specified entity");
            }
        }
    }

    private InputSource buildInputSource(String publicId, String systemId, String fn) throws FileNotFoundException {
        System.out.println("Trying: '" + fn + "'");
        File entitySource = new File(fn);
        if (entitySource.exists()) {
            InputSource entity = new InputSource(new BufferedInputStream(new FileInputStream(entitySource)));
            entity.setPublicId(publicId);
            entity.setSystemId(systemId);
            return entity;
        }
        throw new FileNotFoundException();
    }
}

